'use strict'

var express = require('express');
var ListaOfacController = require('../controllers/restriction');

var api = express.Router();
var md_auth = require('../middlewares/authenticated');

//para subir archivos
var multipart = require('connect-multiparty');
var md_upload = multipart({uploadDir: './uploads/users'});


api.get('/getListaOfacs', md_auth.ensureAuth , ListaOfacController.getPlans);
api.post('/saveList',md_auth.ensureAuth, ListaOfacController.savePlan);
api.get('/getListaOfac/:id', md_auth.ensureAuth,ListaOfacController.getPlan); //para devolver UNO de los planes
api.put('/updateListaOfac/:id',md_auth.ensureAuth, ListaOfacController.updatePlan);
api.delete('/delListaOfac/:id',md_auth.ensureAuth, ListaOfacController.delPlan);
//api.post('/login',  UserController.loginUser);
//api.put('/update-user/:id',md_auth.ensureAuth, UserController.updateUser);
/*api.post('/upload-image', [md_auth.ensureAuth, md_upload],  UserController.uploadImage);
api.get('/get-image-user/:imageFile', UserController.getImageFile);
*/

module.exports = api;