'use strict'

var express = require('express');
var RiskProfileController = require('../controllers/riskProfile');

var api = express.Router();
var md_auth = require('../middlewares/authenticated');

//para subir archivos
//var multipart = require('connect-multiparty');
//var md_upload = multipart({uploadDir: './uploads/users'});
api.post('/saveRiskProfile', md_auth.ensureAuth, RiskProfileController.saveRiskProfile);
api.post('/saveReport', md_auth.ensureAuth, RiskProfileController.saveReport); //Guarda el reporte generado
api.get('/getReportBy/', md_auth.ensureAuth, RiskProfileController.getReportBy);
api.get('/getIdBusqueda/:id', md_auth.ensureAuth, RiskProfileController.getIdBusqueda);
api.get('/getReportByAny/', md_auth.ensureAuth, RiskProfileController.getReportByAny);

api.get('/getRiskProfile/:idProfile', md_auth.ensureAuth, RiskProfileController.getRiskProfile); //para obtener el perfil de riesgo de una person acon el id creado en la busqueda sencilla
api.delete('/delRiskProfile/:idProfile', md_auth.ensureAuth, RiskProfileController.del_RiskProfile); //para eliminar el perfil de riesgo de una person acon el id creado en la busqueda sencilla
api.put('/updateRiskProfile/:idProfile', md_auth.ensureAuth, RiskProfileController.updateRiskProfile); //Actualiza el perfil de riesgo en la busqueda sencilla

module.exports = api;