'use strict'

/***************************************************************/
/*  ROUTER *****************************************************/
/*  Para adaptar:  (*) **** ************************************/
/* *************************************************************/
var express = require('express');
var SearchApiController = require('../controllers/searchapi'); //(*) cambie relation por el nombre del controlador específico

var api = express.Router();
var md_auth = require('../middlewares/authenticated');

api.post('/saveSearchV3', md_auth.ensureAuth, SearchApiController.saveSearchV3); //Funcion para guardar desde BMS
api.post('/saveSearchV2', md_auth.ensureAuth, SearchApiController.saveSearchV2); //Funcion para guardar desde BMP
api.post('/saveSearchBMP', md_auth.ensureAuth, SearchApiController.saveSearchBMP);
api.post('/saveSearch', md_auth.ensureAuth, SearchApiController.saveSearch); //(*) cambie el nombre del controlador
//api.get('/getReportadoSencilla/:nombreAlias/:nit', md_auth.ensureAuth, SearchController.getReportados); //para devolver todos los registros de la base de datos
api.post('/getReportadoSencilla', md_auth.ensureAuth, SearchApiController.getReportados);
api.get('/getSearchApi', md_auth.ensureAuth, SearchApiController.getSearch); // Retorna todas las consultas
api.get('/getSearchCountApi/', md_auth.ensureAuth, SearchApiController.getSearchCount);
//api.get('/getRelation/:id', md_auth.ensureAuth, RelationController.getEntity); //para devolver UNO de los registros de la base de datos
//api.put('/updateRelation/:id',md_auth.ensureAuth, RelationController.updateEntity);
//api.delete('/deleteRelation/:id', md_auth.ensureAuth, RelationController.deleteEntity); //para borrar un usuario dela base de datos

module.exports = api;