'use strict'

var express = require('express');
var TransactionController = require('../controllers/transaction');

var api = express.Router();
var md_auth = require('../middlewares/authenticated');

//para subir archivos
var multipart = require('connect-multiparty');
//var md_upload = multipart({uploadDir: './uploads/users'});




api.post('/transactionSave', md_auth.ensureAuth, TransactionController.saveTransaction);
api.post('/transaction',  md_auth.ensureAuth, TransactionController.saveTransactionExcel);
api.post('/deleteExcel', TransactionController.deleteTransactionExcel);
api.put('/updateTransaction/:id',md_auth.ensureAuth, TransactionController.updateTransaction);
//api.get('/getTransactions/:fIni/:fFin/:id_grabacion',  md_auth.ensureAuth, TransactionController.getTransactions, function(req, res){});
//api.get('/getTransactionsGtMonto/:fIni/:fFin/:monto/:nitConsolidar',  md_auth.ensureAuth, TransactionController.getTransactionsGtMontoEstadistico);
api.get('/getTransactionsByCompany/:fIni/:fFin/:id_company/:id_user',  md_auth.ensureAuth, TransactionController.getTransactionsByCompany);
api.get('/getTransactions/:id_grabacion',  md_auth.ensureAuth, TransactionController.getTransactions, function(req, res){});
//api.get('/getTransactionsGtMonto/:id_grabacion/:monto',  md_auth.ensureAuth, TransactionController.getTransactionsGtMontoEstadistico);


//api.post('/login',  UserController.loginUser);
//api.put('/update-user/:id',md_auth.ensureAuth, UserController.updateUser);
//api.get('/probando', md_auth.ensureAuth,UserController.pruebas);
/*api.post('/upload-image', [md_auth.ensureAuth, md_upload],  UserController.uploadImage);
api.get('/get-image-user/:imageFile', UserController.getImageFile);
*/

module.exports = api;