const express = require('express');
const cors = require('cors');
const { generatePDF } = require('./pdf-generator');

const app = express();
app.use(cors());
app.use(express.json());

app.post('/generate-pdf', async (req, res) => {
  try {
    const { url, htmlContent } = req.body;
    
    // Genera el PDF
    const pdfBuffer = await generatePDF(url, htmlContent);
    
    // Envía el PDF como respuesta
    res.contentType('application/pdf');
    res.send(pdfBuffer);
  } catch (error) {
    console.error('Error generando PDF:', error);
    res.status(500).json({ error: 'No se pudo generar el PDF' });
  }
});

const PORT = process.env.PORT || 1000;
app.listen(PORT, () => {
  console.log(`Servidor de PDF corriendo en puerto ${PORT}`);
});