
import puppeteer from 'puppeteer';


async function runPuppeteer(searchText) {
    const browser = await puppeteer.launch({
        headless: false,
        slowMo: 500,
        //args: ['--no-sandbox', '--disable-setuid-sandbox']
    });


    const page = await browser.newPage();
  
    try {

    //Configurar un user-agent personalizado
    await page.setUserAgent(
        'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36'
    );

      // Navegar a Google
      await page.goto('https://consultaprocesos.ramajudicial.gov.co/Procesos/NombreRazonSocial');

      const selector = '#mainContent > div > div > div > div:nth-child(1) > div > div.mt-1.col.col-12 > div > div.row > div > div > div > div > div.v-input__slot > div > div.v-radio.theme--light.v-item--active > label';
 
    // Verificar si el elemento es visible
    const isElementVisible = await page.evaluate((selector) => {
      const element = document.querySelector(selector);
      return element && element.offsetParent !== null; // offsetParent verifica si el elemento es visible
    }, selector);

    if (isElementVisible) {
      console.log('El elemento está visible. Haciendo clic...');

      // Desplazarse hacia el elemento para asegurarse de que esté en la vista
      await page.evaluate((selector) => {
        const element = document.querySelector(selector);
        if (element) {
          element.scrollIntoView({ behavior: 'smooth', block: 'center' });
        }
      }, selector);

      // Hacer clic en el elemento
      await page.click(selector);

      console.log('Clic realizado correctamente.');
      setTimeout(() => {
        page.close();
      }, 5000);
    } else {
      console.log('El elemento no está visible o no es interactuable.');
    }
  } catch (error) {
    console.error('Error:', error.message);



   

      
    } finally {
      await browser.close();
    }
}

(async () => {
    try {
      const searchText = 'web scraping'; // Cambia esto al texto que deseas buscar
      const results = await runPuppeteer(searchText);
      console.log('los resultados en JSON',JSON.stringify(results, null, 2));
    } catch (error) {
      console.error('Error:', error.message);
    }
  })();