
import puppeteer from 'puppeteer';

async function selectPersonaType(page, personaType) {
  try {
    // Selector para el campo "Tipo de Persona"
    const tipoPersonaSelector = '#mainContent > div > div > div > div:nth-child(1) > div > div.mt-1.col.col-12 > div > div.v-input.theme--light.v-text-field.v-text-field--is-booted.v-select.custom';

    // Esperar a que el campo "Tipo de Persona" esté visible
    await page.waitForSelector(tipoPersonaSelector);

    // Hacer clic en el campo "Tipo de Persona" para abrir el menú
    await page.click(tipoPersonaSelector);

    // Selectores para las opciones "Natural" y "Jurídica"
    const naturalSelector = '#list-64 > div > div:nth-child(1)'; //selector especifico para natural
    const juridicaSelector = '#list-64 > div > div:nth-child(2)'; //selector especifico para juridica

    // Seleccionar la opción deseada
    if (personaType.toLowerCase() === 'natural') {
      // Esperar a que la opcion este visible
      await page.waitForSelector(naturalSelector)
      // Hacer clic en "Natural"
      await page.click(naturalSelector);
      console.log('Seleccionada opción Natural');
    } else if (personaType.toLowerCase() === 'juridica') {
        // Esperar a que la opcion este visible
      await page.waitForSelector(juridicaSelector)
      // Hacer clic en "Jurídica"
      await page.click(juridicaSelector);
      console.log('Seleccionada opción Jurídica');
    } else {
      throw new Error(`Tipo de persona inválido: ${personaType}. Debe ser 'Natural' o 'Juridica'.`);
    }
  } catch (error) {
    console.error('Error al seleccionar el tipo de persona:', error);
    throw error; // Re-lanzar el error para que pueda ser manejado por el llamador.
  }
}

async function run() {
    const browser = await puppeteer.launch({
        headless: false,
        slowMo: 250,
        defaultViewport: null
    });

    const page = await browser.newPage();

    try {
        await page.setUserAgent(
            'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36'
        );
        await page.goto('https://consultaprocesos.ramajudicial.gov.co/Procesos/NombreRazonSocial/');

        // Ejemplo de uso: Seleccionar la opción "Natural"
        await selectPersonaType(page, 'Natural');

        // Ejemplo de uso: Seleccionar la opción "Jurídica"
        // await selectPersonaType(page, 'Juridica');
        
        //continuacion de las instrucciones del programa.

    } catch (error) {
        console.error('Ocurrió un error:', error);
    }finally{
        // await browser.close();
    }

}

run();